/*
 * sysinfo.h		- get kernel info
 *
 */

/* 
 * Written by Gabor Herr <herr@iti.informatik.th-darmstadt.de>.
 *
 * Copyright (c) 1992, 1993 by Gabor Herr, all rights reserved.
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that may name is not used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission. I make no representations
 * about the suitability of this software for any purpose. It is
 * provided "as is" without express or implied warranty.
 */

/* $Id: sysinfo.h,v 1.2 2002/01/30 17:23:09 jdhildeb Exp $ */

//
// modified in 1999, 2000, 2001 by Jason Hildebrand for use with gsysinfo 
//
 
#ifndef SYSINFO_INCLUDED
#define SYSINFO_INCLUDED

#define MAX_SWAPFILES 8
#define MAX_NET_DEVS 10

struct load {
	unsigned long total;
	unsigned long user;
	unsigned long system;
	unsigned long nice;
	unsigned long idle;
};

struct meminfo {
	unsigned long total;
	unsigned long cache;
	unsigned long buffers;
	unsigned long free;
	unsigned long shared;
};

#define AC_ONLINE   0x01

struct apminfo {
    unsigned long has_apm;
	unsigned long acstatus;
	unsigned long battery_perc;	// percentage charged
	unsigned long battery_time;	// in seconds
};

struct netinfo {
	char iface[5];
	unsigned long sent_bytes;
	unsigned long received_bytes;
	unsigned long old_sent_bytes;
	unsigned long old_received_bytes;
};

extern void get_meminfo( int *, struct meminfo * );
extern double get_load(void);
extern void get_cpu(struct load *);
void get_apm_status( struct apminfo * info );
extern int sysinfo_init(void);
extern int get_net_status( struct netinfo * info );

#endif
