/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000-2002 Jason D. Hildebrand
 *  - jason@alumni.uwaterloo.ca
 *  - http://www.opensky.ca/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <time.h>
#include <gnome.h>
#include <gdk/gdkx.h>

extern "C" {
#include <applet-widget.h>
}

#include "gsysinfo.h"
#include "session.h"
#include "gauge.h"

void
gsysinfo_session_load(gchar * cfgpath, GSysInfoData * gd)
{
    gchar * tempstring;
    gchar   propname[ 100 ];
    int		    n;
    int	    gauge_type;
    int	    flag;
    int     conf;

    g_warning( "loading session" );

    gnome_config_push_prefix (cfgpath);

    sprintf( propname, "gsysinfo/configured=%d", 0 );
    conf = gnome_config_get_int_with_default( propname, NULL );
    if( conf ) {

        sprintf( propname, "gsysinfo/bar_breadth=%d", gd->bar_breadth );
        gd->bar_breadth = gnome_config_get_int_with_default( propname, NULL );

        sprintf( propname, "gsysinfo/bar_depth=%d", gd->bar_depth );
        gd->bar_depth  = gnome_config_get_int_with_default( propname, NULL );

        sprintf( propname, "gsysinfo/gap_depth=%d", gd->gap_depth );
        gd->gap_depth  = gnome_config_get_int_with_default( propname, NULL );

        sprintf( propname, "gsysinfo/num_columns=%d", gd->num_columns );
        gd->num_columns  = gnome_config_get_int_with_default( propname, NULL );

        sprintf( propname, "gsysinfo/num_gauges=%d", gd->num_gauges );
        gd->num_gauges = gnome_config_get_int_with_default( propname, NULL );

        for( int n = 0; n < gd->num_gauges; n++ ) {
            if( n <= 4 ) {
                sprintf( propname, "gsysinfo/gaugetype%d=%d", n, gd->gauges[n]->getType() );
            } else {
                sprintf( propname, "gsysinfo/gaugetype%d=%d", n, LOAD_GAUGE );
            }
        gauge_type = gnome_config_get_int_with_default( propname, NULL );
        gd->gauges[n] = new_gauge( (GaugeType) gauge_type );
        sprintf( propname, "gsysinfo/gauge%d_", n );
        gd->gauges[n]->load_session( propname );
        }

        gd->bg_color->load_session( "gsysinfo/background_color" );
    }

    gnome_config_pop_prefix ();
} /* gsysinfo_session_load */

int
gsysinfo_session_save(GtkWidget * w,
		     const char * privcfgpath,
		     const char * globcfgpath,
		     gpointer data)
{
    GSysInfoData *  gd = (GSysInfoData *)data;
    gchar	    propname[ 100 ];
    int		    n;

    gnome_config_push_prefix (privcfgpath);

    gnome_config_set_int( "gsysinfo/bar_breadth", gd->bar_breadth);
    gnome_config_set_int( "gsysinfo/bar_depth", gd->bar_depth );
    gnome_config_set_int( "gsysinfo/gap_depth", gd->gap_depth );
    gnome_config_set_int( "gsysinfo/num_columns", gd->num_columns );
    gnome_config_set_int( "gsysinfo/num_gauges", gd->num_gauges );
    for( n = 0; n < gd->num_gauges; n++ ) {
	sprintf( propname, "gsysinfo/gaugetype%d=0", n );
	gnome_config_set_int( propname, gd->gauges[n]->getType() );
	sprintf( propname, "gsysinfo/gauge%d_", n );
	gd->gauges[n]->save_session( propname );
    }

    gd->bg_color->save_session( "gsysinfo/background_color" );

    gnome_config_set_int( "gsysinfo/configured", 1 );

    gnome_config_pop_prefix ();

    gnome_config_sync ();
    gnome_config_drop_all ();
  
    return FALSE;
} /* gsysinfo_session_save */

void
gsysinfo_session_defaults(GSysInfoData * gd)
{
    int n = 0;
    int dev = -1;
    int dev2 = -1;
    int score = 0;
    int score2 = 0;

    /* Global configurable parameters */
    gd->timeout_t = 1000;
    gd->timeout = 0;
    gd->bar_breadth = 60;
    gd->num_columns = 1;

    gd->tooltip_delay = 750;
    gd->tooltip_timeout = 0;
    gd->tooltipall = 1;
    gd->tooltip_update = FALSE;
      
    gd->need_load = 1;
    gd->need_cpu = 1;
    gd->need_meminfo = 1;
    gd->need_battery = 1;
    gd->need_network = 1;

    gd->gauges[n] = (Gauge *)new LoadGauge;
    n += 1;
    gd->gauges[n] = (Gauge *)new CPUGauge;
    n += 1;
    gd->gauges[n] = (Gauge *)new MemGauge;
    n += 1;
    gd->gauges[n] = (Gauge *)new SwapGauge;
    n += 1;


    // check if machine has APM support
    get_apm_status( &gd->battinfo );
    if( gd->battinfo.has_apm ) {
        gd->gauges[n] = (Gauge *)new BatteryGauge;
        n += 1;
    }


    // pick at most one network device (but not lo)
    // use a scoring system to rank our preference
    gd->numnetdevs = get_net_status( gd->netinfo );
    for( int i = 0; i < gd->numnetdevs; i++ ) {
        
        // prefer ppp0 over eth0 because many people run pppoe
        // and ethernet is just a tunnel in this case
        if( strcmp( gd->netinfo[i].iface, "ppp0" ) == 0 ) {
            if( score < 10 ) {
                score2 = score;
                dev2 = dev;
                score = 10;
                dev = i;
            }
        }
        if( strcmp( gd->netinfo[i].iface, "eth0" ) == 0 ) {
            if( score < 8 ) {
                score2 = score;
                dev2 = dev;
                score = 8;
                dev = i;
            }
        }

        // everything else except lo scores 1.
        if( strcmp( gd->netinfo[i].iface, "lo" ) != 0 ) {
            if( score < 1 ) {
                score2 = score;
                dev2 = dev;
                score = 1;
                dev = i;
            }
        }
    }
    if( score > 0 ) {
        g_warning( "Choosing interface: %s", gd->netinfo[dev].iface );
        NetworkGauge * gauge = new NetworkGauge;
        gauge->set_iface( gd->netinfo[dev].iface );
        gd->gauges[n] = (Gauge *)gauge;
        n += 1;
    }
    if( score2 > 0 && n < 6 ) {
        g_warning( "Choosing interface: %s", gd->netinfo[dev2].iface );
        NetworkGauge * gauge = new NetworkGauge;
        gauge->set_iface( gd->netinfo[dev2].iface );
        gd->gauges[n] = (Gauge *)gauge;
        n += 1;
    }
    gd->num_gauges = n;

    if( n == 4 ) {
        gd->bar_depth = 6;
        gd->gap_depth = 6;
    }
    if( n == 5 ) {
        gd->bar_depth = 5;
        gd->gap_depth = 4;
    }
    if( n == 6 ) {
        gd->bar_depth = 4;
        gd->gap_depth = 4;
    }


    gd->bg_color = new Color( "Background", "background", "#FFFFFF");
    gd->new_bg_color = NULL;
} /* gsysinfo_session_defaults */
