/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000-2002 Jason D. Hildebrand
 *  - jason@alumni.uwaterloo.ca
 *  - http://www.opensky.ca/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

/* #include <config.h> */
#include <stdio.h>
#include <gnome.h>
#include <glib.h>
#include <gdk/gdk.h>
#include "gsysinfo.h"
#include "properties.h"
#include "gauge.h"
#include "gaugeprops.h"


static int prop_cancel (GtkWidget * w, gpointer data);
static void prop_apply (GtkWidget *w, int page, gpointer data);
//static void color_set_cb( GnomeColorPicker *widget, gpointer data );



// Properties
//
// - turn each bar on/off
// - change all colors
// - adjust size
// - adjust orientation
// - adjust update frequency

/* Create the properties window */
void
create_properties_window (AppletWidget * applet, gpointer data)
{
    static GnomeHelpMenuEntry help_entry = { NULL, "properties" };
    GSysInfoData * gd = (GSysInfoData *)data; 
    GtkWidget * vb, * l, *colours, * hb, * gaugebox;
    GtkWidget *bgc;
    GtkWidget * timeout_spin;
    //GtkWidget * numgauges_spin;
    GtkWidget * width_spin;
    GtkWidget * height_spin;
    GtkWidget * gap_spin;
    GtkWidget * columns_spin;
    //int r, g, b;
    int n;
    //GdkColor mycol;

    help_entry.name = gnome_app_id;

    if (gd->prop_win) {
        
        // clear all gauges from the property box
        while( gd->gaugeprops->get_num_gauges() > 0 ) {
            gd->gaugeprops->del_gauge();
        }
        for( n = 0; n < gd->num_gauges; n++ ) {
            // make a clone of each gauge and put it in the properties
            gd->gaugeprops->add_gauge( gd->gauges[n]->clone() );
        }

        gtk_notebook_set_page( GTK_NOTEBOOK(gd->prop_win->notebook), 0 );
  
        gtk_widget_show (GTK_WIDGET (gd->prop_win));
        gdk_window_raise (GTK_WIDGET (gd->prop_win)->window);
  
        // TODO: should copy the current geometry values from gd 
        // into the widgets here
        gtk_adjustment_set_value( GTK_ADJUSTMENT( gd->timeout_adj ), (float)gd->timeout_t );
        //gtk_adjustment_set_value( GTK_ADJUSTMENT( gd->numgauges_adj  ), (float)gd->num_gauges );
        gtk_adjustment_set_value( GTK_ADJUSTMENT( gd->width_adj ), (float)gd->bar_breadth );
        gtk_adjustment_set_value( GTK_ADJUSTMENT( gd->height_adj ), (float)gd->bar_depth );
        gtk_adjustment_set_value( GTK_ADJUSTMENT( gd->gap_adj ), (float)gd->gap_depth );
        gtk_adjustment_set_value( GTK_ADJUSTMENT( gd->columns_adj ), (float)gd->num_columns );
        
        if( gd->new_bg_color != NULL ) {
            delete gd->new_bg_color;
        }
        gd->new_bg_color = gd->bg_color->clone();
        return;
    }
        
    gd->prop_win = GNOME_PROPERTY_BOX (gnome_property_box_new ());
  
    gnome_dialog_close_hides
      (GNOME_DIALOG (& (gd->prop_win->dialog)), TRUE);

    gtk_window_set_title (
          GTK_WINDOW (&GNOME_PROPERTY_BOX (gd->prop_win)->dialog.window),
          _("GSysInfo Settings"));
    
    /*
     *
     * General Properties
     *
     */
    vb = gtk_vbox_new ( FALSE, 10 );
    gnome_property_box_append_page (GNOME_PROPERTY_BOX (gd->prop_win), vb,
                                    gtk_label_new (_("General")));


    // create widget for adjusting update speed
    hb = gtk_hbox_new( FALSE, 10 );
    l = gtk_label_new (_("Delay between updates (milliseconds):")); 
    gtk_box_pack_start_defaults( GTK_BOX( hb ), l );

    gd->timeout_adj = gtk_adjustment_new ( (gfloat) gd->timeout_t, 
                                           (gfloat) 100, 
                                           (gfloat) 100000, 
                                           (gfloat) 100, 
                                           (gfloat) 1000, 
                                           (gfloat) 100 );
    timeout_spin = gtk_spin_button_new ( GTK_ADJUSTMENT (gd->timeout_adj), 1, 0 );
    gtk_box_pack_start_defaults( GTK_BOX( hb ), timeout_spin );
    gtk_box_pack_start_defaults( GTK_BOX( vb ), hb );
    gtk_spin_button_set_update_policy ( GTK_SPIN_BUTTON (timeout_spin),
                                       GTK_UPDATE_ALWAYS );
    gtk_signal_connect (GTK_OBJECT (gd->timeout_adj), "value_changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);
    gtk_signal_connect (GTK_OBJECT (timeout_spin), "changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);

    // create widget for adjusting the background color
    gd->new_bg_color = gd->bg_color->clone();
    gtk_box_pack_start( GTK_BOX( vb ), 
                        gd->new_bg_color->new_props( gd->prop_win ), TRUE, FALSE, 0  );


    /*
     *
     * Gauge Properties
     *
     */
    gaugebox = gtk_vbox_new( FALSE, 5 );
    gd->gaugeprops = new GaugeProps( gd->prop_win, gaugebox );

    for( n = 0; n < gd->num_gauges; n++ ) {
        // make a clone of each gauge and put it in the properties
        gd->gaugeprops->add_gauge( gd->gauges[n]->clone() );
    }
    gnome_property_box_append_page (GNOME_PROPERTY_BOX (gd->prop_win), gaugebox,
                                    gtk_label_new (_("Gauges")));


    /*
     *
     * Layout Properties
     *
     */
    vb = gtk_vbox_new ( FALSE, 10 );
    gnome_property_box_append_page (GNOME_PROPERTY_BOX (gd->prop_win), vb,
                                    gtk_label_new (_("Layout")));

    // create widget for adjusting applet width
    hb = gtk_hbox_new( FALSE, 10 );
    l = gtk_label_new (_("Gauge Width:")); 
    gtk_box_pack_start_defaults ( GTK_BOX (hb), l ); 
    gd->width_adj = gtk_adjustment_new ( (gfloat) gd->bar_breadth,
                                           (gfloat) 20, 
                                           (gfloat) 400, 
                                           (gfloat) 10, 
                                           (gfloat) 20, 
                                           (gfloat) 20 );
    width_spin = gtk_spin_button_new ( GTK_ADJUSTMENT (gd->width_adj), 1, 0 );
    gtk_box_pack_start_defaults( GTK_BOX (hb), width_spin );
    gtk_box_pack_start_defaults( GTK_BOX (vb), hb );
    gtk_spin_button_set_update_policy ( GTK_SPIN_BUTTON (width_spin),
                                       GTK_UPDATE_ALWAYS );
    gtk_signal_connect (GTK_OBJECT (gd->width_adj), "value_changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);
    gtk_signal_connect (GTK_OBJECT (width_spin), "changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);


    // create widget for adjusting height of gauges
    l = gtk_label_new (_("Gauge Height:")); 
    hb = gtk_hbox_new( FALSE, 10 );
    gtk_box_pack_start_defaults( GTK_BOX (hb), l ); 
  
    gd->height_adj = gtk_adjustment_new ( (gfloat) gd->bar_depth,
                                           (gfloat) 2, 
                                           (gfloat) 100, 
                                           (gfloat) 1, 
                                           (gfloat) 4, 
                                           (gfloat) 4 );
    height_spin = gtk_spin_button_new ( GTK_ADJUSTMENT (gd->height_adj), 1, 0 );
    gtk_box_pack_start_defaults( GTK_BOX (hb), height_spin );
    gtk_box_pack_start_defaults( GTK_BOX (vb), hb );
    gtk_spin_button_set_update_policy ( GTK_SPIN_BUTTON (height_spin),
                                       GTK_UPDATE_ALWAYS );
    gtk_signal_connect (GTK_OBJECT (gd->height_adj), "value_changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);
    gtk_signal_connect (GTK_OBJECT (height_spin), "changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);

    // create widget for adjusting vertical spacing (space between gauges)
    l = gtk_label_new (_("Vertical Spacing:")); 
    hb = gtk_hbox_new( FALSE, 10 );
    gtk_box_pack_start_defaults( GTK_BOX (hb), l ); 
  
    gd->gap_adj = gtk_adjustment_new ( (gfloat) gd->gap_depth,
                                           (gfloat) 1, 
                                           (gfloat) 20, 
                                           (gfloat) 1, 
                                           (gfloat) 4, 
                                           (gfloat) 4 );
    gap_spin = gtk_spin_button_new ( GTK_ADJUSTMENT (gd->gap_adj), 1, 0 );
    gtk_box_pack_start_defaults( GTK_BOX (hb), gap_spin );
    gtk_box_pack_start_defaults( GTK_BOX (vb), hb );
    gtk_spin_button_set_update_policy ( GTK_SPIN_BUTTON (gap_spin),
                                       GTK_UPDATE_ALWAYS );
    gtk_signal_connect (GTK_OBJECT (gd->gap_adj), "value_changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);
    gtk_signal_connect (GTK_OBJECT (gap_spin), "changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);

    // create widget for specifying number of columns
    l = gtk_label_new (_("Number of columns:")); 
    hb = gtk_hbox_new( FALSE, 10 );
    gtk_box_pack_start_defaults( GTK_BOX (hb), l ); 
  
    gd->columns_adj = gtk_adjustment_new ( (gfloat) gd->num_columns,
                                           (gfloat) 1, 
                                           (gfloat) 10, 
                                           (gfloat) 1, 
                                           (gfloat) 2, 
                                           (gfloat) 2 );
    columns_spin = gtk_spin_button_new ( GTK_ADJUSTMENT (gd->columns_adj), 1, 0 );
    gtk_box_pack_start_defaults( GTK_BOX (hb), columns_spin );
    gtk_box_pack_start_defaults( GTK_BOX (vb), hb );
    gtk_spin_button_set_update_policy ( GTK_SPIN_BUTTON (columns_spin),
                                       GTK_UPDATE_ALWAYS );
    gtk_signal_connect (GTK_OBJECT (gd->columns_adj), "value_changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);
    gtk_signal_connect (GTK_OBJECT (columns_spin), "changed",
                       GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);


    /** Standard things */
    gtk_signal_connect (GTK_OBJECT (gd->prop_win), "destroy",
                        GTK_SIGNAL_FUNC (prop_cancel), gd);
          
    gtk_signal_connect (GTK_OBJECT (gd->prop_win), "delete_event",
                        GTK_SIGNAL_FUNC (prop_cancel), gd);
          
    gtk_signal_connect (GTK_OBJECT (gd->prop_win), "apply",
                        GTK_SIGNAL_FUNC (prop_apply), gd);
  
    gtk_signal_connect (GTK_OBJECT (gd->prop_win), "help",
                        GTK_SIGNAL_FUNC (gnome_help_pbox_display),
                        &help_entry);
        
    gtk_notebook_set_page( GTK_NOTEBOOK(gd->prop_win->notebook), 1 );
    gtk_widget_show_all (GTK_WIDGET (gd->prop_win));

} /* properties_window */


/*
 *
 * Properties window button callbacks (apply, cancel, etc)
 *
 */
static int
prop_cancel (GtkWidget * w, gpointer data)
{
  GSysInfoData * gd = (GSysInfoData *)data;

  return FALSE;
} /* prop_cancel */

static void
prop_apply (GtkWidget *w, int page, gpointer data)
{
    GSysInfoData * gd = (GSysInfoData *)data;
    int timeoutval, val; 
    gchar *fn;
    int            i;

    /*
     * Update the running session from the properties.  The session
     * state will be saved when the applet exits and the panel tells it
     * to save state.
     */

    /*
     * Don't let the update function run while we're changing these
     * values.
     */
    gd->setup = FALSE;
  
    /*
     * Update the timeout interval
     */
    timeoutval = (int)(GTK_ADJUSTMENT (gd->timeout_adj)->value);
  
    if (timeoutval != gd->timeout_t) {
      gd->timeout_t = timeoutval;
      set_update_event( gd );
    }
  
    /*
     * Update the layout 
     */
    val = (int)(GTK_ADJUSTMENT (gd->width_adj)->value);
    if (val != gd->bar_breadth ) {
        gd->bar_breadth  = val;
    }
    val = (int)(GTK_ADJUSTMENT (gd->height_adj)->value);
    if (val != gd->bar_depth ) {
        gd->bar_depth  = val;
    }
    val = (int)(GTK_ADJUSTMENT (gd->gap_adj)->value);
    if (val != gd->gap_depth ) {
        gd->gap_depth  = val;
    }
    val = (int)(GTK_ADJUSTMENT (gd->columns_adj)->value);
    if (val != gd->num_columns ) {
        gd->num_columns = val;
    }

    // delete the existing gauges
    for( i = 0; i < gd->num_gauges; i++ ) {
        delete gd->gauges[i];
    }

    // take the properties gauges and use them
    // insert the gauges into the container, and set the events
    gd->num_gauges = gd->gaugeprops->get_num_gauges();
    for( i = 0 ; i < gd->num_gauges; i++ ) {
        gd->gauges[i] = gd->gaugeprops->gauges[i]->clone();
        gd->gauges[i]->add_to_container( gd->fixed );
        gtk_signal_connect (GTK_OBJECT (gd->gauges[i]->area), "expose_event",
                           (GtkSignalFunc)expose_handler, gd);
        gtk_widget_set_events (gd->gauges[i]->area, GDK_EXPOSURE_MASK );
    }
    determine_needed_info( gd );

    // update the background color
    if( gd->bg_color != NULL ) {
        delete gd->bg_color;
    }
    gd->bg_color = gd->new_bg_color->clone();

    configure_layout( gd );
    gsysinfo_set_size (gd);
  
    gd->setup = TRUE;
  
    /* Make the panel save our config */
    applet_widget_sync_config (APPLET_WIDGET (gd->applet));
  
} /* prop_apply */

/*
 *
 * Property element callbacks (whenever a property is changed one of
 * these is called)
 *
 */

void
adj_value_changed_cb ( GtkAdjustment * adj, gpointer data )
{
    GSysInfoData * gd = (GSysInfoData *)data;
    int                        num;
    
#if 0
    if( adj == GTK_ADJUSTMENT( gd->numgauges_adj ) ) {
        // adjust the number of gauges in the prop box
        num = (int)(GTK_ADJUSTMENT (gd->numgauges_adj)->value);
        for( ; ; ) {
            if( num > gd->gaugeprops->get_num_gauges()) {
                // need to add a gauge
                gd->gaugeprops->add_gauge();
            } else if( num < gd->gaugeprops->get_num_gauges() ) {
                // need to delete a gauge
                gd->gaugeprops->del_gauge();
            } else {
                break;
            }
        }
    }
#endif

    gnome_property_box_changed (GNOME_PROPERTY_BOX (gd->prop_win)); 
} /* value_changed_cb */
