/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000-2002 Jason D. Hildebrand
 *  - jason@alumni.uwaterloo.ca
 *  - http://www.opensky.ca/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef _GNOMESYSINFO_H
#define _GNOMESYSINFO_H

/* I dunno what PACKAGE means... */
#define PACKAGE "gnome-core"
#define VERSION "2.0"

extern "C" {
#include <applet-widget.h>
}

#include "sysinfo.h"
#include "color.h"

#define MAX_SWAP_FILES                    8
#define MAX_GAUGES                    8

#ifdef DEBUG
extern FILE * debugfile;
#define DEBUG_FILENAME "/tmp/gsysinfo_debug"
#define DEBUG_LOG( str )   fprintf( debugfile, str ); fflush( debugfile )
#define DEBUG_LOG2( str, arg )   fprintf( debugfile, str, arg )
#else
#define DEBUG_LOG
#define DEBUG_LOG2
#endif

class Gauge;
class GaugeProps;

typedef struct GSysInfoData {
    GtkWidget *applet;
    GtkFixed *fixed;

    //gint breadth, depth;
    gint bar_breadth, bar_depth;
    gint gap_depth;
    gint num_columns;

    Color * bg_color;
  
    int            num_gauges;
    Gauge * gauges[MAX_GAUGES];
  
    gboolean setup, vertical;
  
    gboolean toggle;
    time_t toggle_t;
  
    guint timeout;    // timeout handle
    gint timeout_t;   // value of timeout interval (in milliseconds)
  
    /* Widgets n stuff... */
  
    // other stuff
    GdkPixmap *pixmap;
    GdkImage *image;
    GdkGC *gc;
  
    GtkWidget *about_box;
  
    //GtkTooltips * tooltips;
    gboolean tooltipall;    // whether _all_ info should be displayed in tooltip,
                            // or just that info which is in the current gauges
    GtkWidget * tooltipwin;
    GtkWidget * tooltiplabel;
    char                tooltip[ 512 ];
    gboolean        tooltip_update;
    guint tooltip_timeout;
    gint  tooltip_delay;
  
    /*
     *
     * For the  "Properties" window ...
     *
     */
    GnomePropertyBox *prop_win;
    GaugeProps        * gaugeprops;

  
    /* General */
    GtkObject *timeout_adj;
    //GtkObject *numgauges_adj;
    GtkObject *width_adj;
    GtkObject *height_adj;
    GtkObject *gap_adj;
    GtkObject *columns_adj;
    Color *    new_bg_color;

  
    // these flags tell us whether we need to fetch certain
    // information.  They are set according to which gauges
    // are in use.
    int need_load;
    int need_cpu;
    int need_meminfo;
    int need_battery;
    int need_network;
  
    struct meminfo memstats[ MAX_SWAP_FILES ];
    struct apminfo battinfo;
    struct netinfo netinfo[ MAX_NET_DEVS ];
    struct load curload;
    double loadavg;
    int numswapfiles;
    int numnetdevs;
    int swap;
  
} GSysInfoData;

#define MERLIN_CLOCK_TOGGLE_PERIOD 3

/*
 *
 * Configuration defaults
 *
 */


#define MERLIN_CLOCK_DATEMODE_TIME "time"
#define MERLIN_CLOCK_DATEMODE_DATE "date"

/* Global configuration parameters */
#define MERLIN_CLOCK_DEFAULT_DATEMODE        "time"
#define MERLIN_CLOCK_DEFAULT_BREADTH         "48"
#define MERLIN_CLOCK_DEFAULT_EXTENDED        "false"
#define MERLIN_CLOCK_DEFAULT_FOREGROUND      "#FFFF00"
#define MERLIN_CLOCK_DEFAULT_BACKGROUND      "#52080A"
#define MERLIN_CLOCK_DEFAULT_FONT            "fixed"

/*
 *
 * Prototypes
 *
 */

void about_cb (AppletWidget *widget, gpointer data);
void destroy_about(GtkWidget *w, gpointer data);

void gsysinfo_set_size(GSysInfoData *gd);
gint gsysinfo_update(gpointer data);
gint orient_handler(GtkWidget *w, PanelOrientType o,
                                   gpointer data);
gint expose_handler(GtkWidget *widget, GdkEventExpose *expose,
                                   gpointer data);
GtkWidget *make_new_gsysinfo_applet (const gchar *goad_id);
void gsysinfo_create_gc(GSysInfoData *gd);
void set_update_event (GSysInfoData *gd);
GtkWidget *applet_start_new_applet (const gchar *goad_id,
                                     const char **params, int nparams);
void configure_layout( GSysInfoData * gd );
void determine_needed_info( GSysInfoData * gd );

extern GSysInfoData * gd;

#endif /* GNOMESYSINFO_H */
