/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000-2002 Jason D. Hildebrand
 *  - jason@alumni.uwaterloo.ca
 *  - http://www.opensky.ca/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef GAUGEPROPS_INCLUDED
#define GAUGEPROPS_INCLUDED

#include "gsysinfo.h"
#include "gauge.h"


class GaugeProps 
{
  protected:
    GtkWidget * buttons[MAX_GAUGES];
    GtkWidget * props;
    GtkWidget * list;           
    GtkWidget * box;        // box in which we can put all of the widgets
    int                numgauges;

    GnomePropertyBox *prop_win;

  public:
    Gauge *        gauges[MAX_GAUGES];            // temporary gauges
    GaugeProps( GnomePropertyBox * propbox, GtkWidget * gaugebox );

    void button_clicked( GtkWidget * button );

    // add a gauge to the properties, or create and add a gauge if NULL is passed
    void add_gauge( Gauge * gauge = NULL );
    void del_gauge( int i = -1 );
    void move_gauge( int oldpos, int newpos );
    void display_selected_gauge();
    void del_selected_gauge();
    Gauge * remove_last_gauge();

    void menu_popup( GdkEventButton *event );

    int get_num_gauges();
};


#endif
