/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000-2002 Jason D. Hildebrand
 *  - jason@alumni.uwaterloo.ca
 *  - http://www.opensky.ca/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include "gaugeprops.h"
#include "gauge.h"

// the number of "normal" (non-dynamic) property pages
// currently: general
//#define NUM_STATIC_PROP_PAGES 2

static void gauge_button_clicked(GtkWidget *button, gpointer data)
{
    GaugeProps * props = (GaugeProps *)data;
    props->button_clicked( button );
}

void GaugeProps::button_clicked( GtkWidget * button )
{
    int      i;        // index of the gauge which changed
    Gauge *  gauge;
    
    // figure out which gauge changed, and to what gauge type it should
    // be changed
    for( i = 0; i < LAST_GAUGE; i++ ) {
        if( button == buttons[i] ) {
            break;
        }
    }
    gauge = new_gauge( (GaugeType)i );
    add_gauge( gauge );
    gnome_property_box_changed (GNOME_PROPERTY_BOX (prop_win)); 
}

static void row_moved( GtkCList *clist,
                       gint oldpos,
                       gint newpos,
                       gpointer data )
{
    GaugeProps * props = (GaugeProps *)data;
    props->move_gauge( oldpos, newpos );
}

void GaugeProps::move_gauge( int oldpos, int newpos )
{
    int      i;        // index of the gauge which changed
    Gauge *  gauge;
    //GtkWidget * proppage;
    
    gauge = gauges[ oldpos ];
    //proppage = proppages[ oldpos ];
    if( newpos < oldpos ) {
        // shuffle all gauges forward one slot
        for( i = oldpos; i > newpos; i-- ) {
            gauges[i] = gauges[i-1];
            //proppages[i] = proppages[i-1];
        }
    } else if( newpos > oldpos ) {
        // shuffle all gauges backward one slot
        for( i = oldpos; i < newpos; i++ ) {
            gauges[i] = gauges[i+1];
            //proppages[i] = proppages[i+1];
        }
    }
    gauges[newpos] = gauge;
    //proppages[newpos] = proppage;
    gnome_property_box_changed (GNOME_PROPERTY_BOX (prop_win)); 
}

static gint test_idle_func( gpointer data )
{
    GaugeProps * props = (GaugeProps *)data;
    props->display_selected_gauge();
    return( FALSE );
}

static void button_press_event( GtkWidget *widget,
                                GdkEventButton *event,
                                gpointer data )
{
    GaugeProps * props = (GaugeProps *)data;
    GdkEventType type;
  
    type = event->type;
    if( type == GDK_BUTTON_PRESS ) {
        if( event->button == 3 ) {
            props->menu_popup( event );
        } 
    } else if( type == GDK_2BUTTON_PRESS ) {
        gtk_idle_add( test_idle_func, props );
    }
}


static void prop_activate( GtkMenuItem *item,
                           gpointer data )
{
    GaugeProps * props = (GaugeProps *)data;
    props->display_selected_gauge();
}

static void del_activate( GtkMenuItem *item,
                          gpointer data )
{
    GaugeProps * props = (GaugeProps *)data;
    props->del_selected_gauge();
}

void GaugeProps::display_selected_gauge()
{
    GtkWidget * win;
    Gauge * gauge;
    char winname[ 100 ];
    GList * sel = GTK_CLIST(list)->selection;
    if( sel != NULL ) {
        gauge = gauges[ (int)sel->data ];
        sprintf( winname, "%s Properties", gauge->getName( SHORTNAME ) );
        win = gnome_dialog_new( winname, GNOME_STOCK_BUTTON_OK, NULL );
        props = gauges[ (int)sel->data ]->new_proppage( prop_win );
        gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (win)->vbox), props, TRUE, TRUE, 0);
        gtk_window_set_default_size( GTK_WINDOW( win ), 200, 300 );
        //gtk_widget_set_usize( win, 200, 300 );
        gtk_widget_show_all( win );
        gnome_dialog_run_and_close( GNOME_DIALOG( win ) );
        gtk_clist_set_text( GTK_CLIST( list ), (int)sel->data, 0, gauge->getName( LONGNAME ) );
    }
}

void GaugeProps::del_selected_gauge()
{
    GList * sel = GTK_CLIST(list)->selection;
    if( sel != NULL ) {
        del_gauge( (int)sel->data );
    }
}


void GaugeProps::menu_popup( GdkEventButton *event )
{
    int      i;        // index of the gauge which changed
    Gauge *  gauge;
    GtkWidget * proppage;
    GtkWidget * menu;
    GtkWidget * delitem; 
    GtkWidget * propitem; 
    
    propitem = gtk_menu_item_new_with_label( "Properties" );
    gtk_signal_connect( GTK_OBJECT( propitem ), "activate", GTK_SIGNAL_FUNC(prop_activate), this );
    gtk_widget_show( propitem );
    

    delitem = gtk_menu_item_new_with_label( "Delete" );
    gtk_signal_connect( GTK_OBJECT( delitem ), "activate", GTK_SIGNAL_FUNC(del_activate), this );
    gtk_widget_show( delitem );

    menu = gtk_menu_new();
    gtk_menu_append( GTK_MENU( menu ), propitem );
    gtk_menu_append( GTK_MENU( menu ), delitem );
    gtk_menu_popup( GTK_MENU( menu ), NULL, NULL, NULL, NULL, event->button, event->time );
    //menu.popup(None, None, None, event.button, event.time)
    gtk_widget_show( menu );

    gnome_property_box_changed (GNOME_PROPERTY_BOX (prop_win)); 
}


GaugeProps::GaugeProps( GnomePropertyBox * propbox, GtkWidget * gaugebox )
{
    numgauges = 0;
    prop_win = propbox;
    box = gaugebox;
    GtkWidget * hb;
    GtkWidget * vb;
    char buttonname[100];

    hb = gtk_hbox_new( FALSE, 10 );
    vb = gtk_vbox_new( FALSE, 10 );

    gtk_box_pack_start( GTK_BOX( box ), gtk_label_new( "Use buttons to create gauges.  Re-order gauges by dragging.\nEdit or delete gauges by right-clicking." ), FALSE, FALSE, 10 );

    // create buttons for making new gauges
    for( int i = 0; i < LAST_GAUGE; i++ ) {
        sprintf( buttonname, "Add %s gauge", GaugeNames[i][SHORTNAME] );
        buttons[i] = gtk_button_new_with_label( buttonname );
        gtk_signal_connect (GTK_OBJECT (buttons[i]), "clicked",
                           GTK_SIGNAL_FUNC (gauge_button_clicked), (void *)this );
        gtk_box_pack_start( GTK_BOX( vb ), buttons[i], FALSE, FALSE, 0 );
    }

    list = gtk_clist_new( 1 );
    gtk_clist_set_use_drag_icons( GTK_CLIST( list ), FALSE );
    gtk_clist_set_reorderable( GTK_CLIST( list ), TRUE );
    gtk_signal_connect (GTK_OBJECT (list), "row-move",
                        GTK_SIGNAL_FUNC (row_moved), (void *)this );
    gtk_signal_connect (GTK_OBJECT (list), "button_press_event",
                        GTK_SIGNAL_FUNC (button_press_event), (void *)this );
	gtk_widget_set_events ( list, GDK_BUTTON_PRESS_MASK );


    gtk_box_pack_start( GTK_BOX( hb ), vb, FALSE, FALSE, 10 );
    gtk_box_pack_start( GTK_BOX( hb ), list, TRUE, TRUE, 10 );
    gtk_box_pack_start_defaults( GTK_BOX( box ), hb );
}

int GaugeProps::get_num_gauges()
{
    return numgauges;
}

void GaugeProps::add_gauge( Gauge * newgauge )
{
    char * item[2];

    if( newgauge == NULL ) {
        return;
    }

    // add gauge name to clist
    item[0] = (char *)newgauge->getName( LONGNAME );
    item[1] = NULL;
    gtk_clist_append( GTK_CLIST( list ), item );

    gauges[numgauges] = newgauge;
    //proppages[numgauges] = newgauge->new_proppage( prop_win );
    //gnome_property_box_append_page( prop_win, 
                                    //proppages[numgauges],
                                    //gtk_label_new( newgauge->getName( SHORTNAME ) ) );
    
    // add the dropdown box for selecting the gauge type
    //dropdowns[numgauges] = gauge_dropdown_new( newgauge->getType() );
    //gtk_box_pack_start( GTK_BOX( dropdownbox ), 
                        //dropdowns[numgauges], TRUE, FALSE, 0 );
    numgauges += 1;
}

void GaugeProps::del_gauge(int i)
{
    char * item[2] = { "dummy", NULL };

    // move the gauge-to-delete to the end, then delete it
    if( i >= 0 && i < numgauges ) {
        move_gauge( i, numgauges - 1 );
        gtk_clist_remove( GTK_CLIST( list ), i );
        gtk_clist_append( GTK_CLIST( list ), item );
    } 
    delete remove_last_gauge();
}

Gauge * GaugeProps::remove_last_gauge()
{
    numgauges -= 1;
    //GtkWidget * nb = prop_win->notebook;
    
    // remove the last page of the notebook
    //gtk_notebook_remove_page( GTK_NOTEBOOK( nb ), -1 );
    gtk_clist_remove( GTK_CLIST( list ), numgauges );
    //gtk_object_unref( GTK_OBJECT( proppages[numgauges] ) );

    // remove the dropdown
    //gtk_container_remove( GTK_CONTAINER( dropdownbox ), dropdowns[ numgauges ] );
    //gtk_object_unref( GTK_OBJECT( dropdowns[numgauges] ) );

    return( gauges[ numgauges ] );
}
