/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000-2002 Jason D. Hildebrand
 *  - jason@alumni.uwaterloo.ca
 *  - http://www.opensky.ca/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef GAUGE_H_INCLUDED
#define GAUGE_H_INCLUDED

#include "gsysinfo.h"
#include "color.h"

enum GaugeType {
    LOAD_GAUGE, 
    CPU_GAUGE, 
    MEM_GAUGE, 
    SWAP_GAUGE, 
    BATTERY_GAUGE, 
    NETWORK_GAUGE,
    LAST_GAUGE
};

#define LONGNAME 0
#define SHORTNAME 1
extern char * GaugeNames[][2];

// creates a properties page (for the appropriate gauge) to be attached to the
// properties box.  Note that there is no Gauge widget attached to this
// property page; one will be created when the properties are applied
GtkWidget * new_gauge_proppage( GaugeType type );

// creates a new gauge (of the specified type)
Gauge *        new_gauge( GaugeType type );

#define max_colors_per_gauge        10


typedef struct GSysInfoData;

class Gauge {
  protected:
    GaugeType        type;        // the type of gauge this is

    int pixmap_x;        // coordinates on the pixmap which this gauge 
    int pixmap_y;        // uses for drawing itself
    GtkFixed * container;
    
    Color *  colors[max_colors_per_gauge];
    
  public:
    Gauge();
    ~Gauge();

    virtual Gauge * clone();        // create a clone of this gauge

    // create a property page for gauge type
    virtual GtkWidget * new_proppage( GnomePropertyBox * propwin );        
    
    virtual const char * getName( int nametype ); // get the name of the gauge
    GtkWidget *        area;        // drawing area
    GtkWidget *        frame;        // frame (which draws the bevelling according 
                        // to chosen theme)

    // copy the region of the pixmap to the drawing area
    void Display( GSysInfoData * gd );

    // draw the gauge onto the pixmap
    virtual void Draw( GSysInfoData * gd, 
                       int bar_breadth, 
                       int bar_depth ) = 0;

    void SetPixmapPos( int x, int y ) 
    {
        pixmap_x = x;
        pixmap_y = y;
    }

    void add_to_container( GtkFixed * container );
    GaugeType getType() { return type; };

    virtual void save_session( char * prefix );
    virtual void load_session( char * prefix );
};


class LoadGauge : Gauge {
  protected:

    enum Colors {
        LOADAVGBAR0,
        LOADAVGBAR1,
        LOADAVGBAR2,
        LOADAVGBAR3,
        LOADAVGBAR4,
        LOADAVGBAR5,
        LOADAVGBAR6,
        LOADAVGBAR7,
        LOADAVGBAR8,
        LOADAVGBAR9
    };

  public:
    LoadGauge();
    virtual void Draw( GSysInfoData * gd, 
                       int bar_breadth, 
                       int bar_depth );
};

class CPUGauge : Gauge {
  protected:

    enum Colors {
        LOADBAR,
        LOADBAR1,
        LOADBAR2
    };

  public:
    CPUGauge();
    virtual void Draw( GSysInfoData * gd, 
                       int bar_breadth, 
                       int bar_depth );
};

class MemGauge : Gauge {
  protected:

    enum Colors {
        MEMBAR0,
        MEMBAR1
    };

  public:
    MemGauge();
    virtual void Draw( GSysInfoData * gd, 
                       int bar_breadth, 
                       int bar_depth );
};

class SwapGauge : Gauge {
  protected:

    enum Colors {
        SWAPBAR
    };

  public:
    SwapGauge();
    virtual void Draw( GSysInfoData * gd, 
                       int bar_breadth, 
                       int bar_depth );
};


class BatteryGauge : Gauge {
  protected:

    enum Colors {
        ONLINE,
        OFFLINE
    };

  public:
    BatteryGauge();
    virtual void Draw( GSysInfoData * gd, 
                       int bar_breadth, 
                       int bar_depth );
};

class NetworkGauge : Gauge {
  protected:
    GtkWidget *                combo;
    GList     *                ifaces;
    GnomePropertyBox *        prop_win;

    enum Colors {
        SEND,
        RECEIVE,
        OFFLINE
    };
    char interface[10];
    char gaugename[20];
    int index;
    int prev_sent;        // previous number of bytes sent
    int prev_received;  // previous number of bytes received
    int bandwidth;
    int offline;

  public:
    NetworkGauge();
    ~NetworkGauge();

    virtual Gauge * clone();        // create a clone of this gauge

    virtual void Draw( GSysInfoData * gd, 
                       int bar_breadth, 
                       int bar_depth );
    virtual void FindInterface( GSysInfoData * gd );
    virtual const char * getName( int nametype ); // get the name of the gauge
    GtkWidget * new_proppage( GnomePropertyBox * propwin );
    void set_iface( char * iface );
    virtual void save_session( char * prefix );
    virtual void load_session( char * prefix );
};


#endif
