/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000-2002 Jason D. Hildebrand
 *  - jason@alumni.uwaterloo.ca
 *  - http://www.opensky.ca/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef COLOR_H_INCLUDED 
#define COLOR_H_INCLUDED 

#include <gnome.h>

#define max_rgb_str_size	    16

class Color {
  protected:
    char *	name;
    char *	identifier;
    gchar	stringval[max_rgb_str_size];
    GdkColor	value;
    GtkWidget *	cp;	// color picker widget
    GnomePropertyBox *prop_win;		    

  public:
    // initialize the colour
    Color( char * newname, char * id, char * defaultcolor );
    ~Color();

    Color * clone();	// clone this color

    // allocate the color
    // allocate( gc );

    virtual void save_session( char * prop );
    virtual void load_session( char * prop );

    // use the color for drawing
    void use( GdkGC * gc );
    //void apply();   // apply properties (i.e. allocate the new color)
    GtkWidget * new_props( GnomePropertyBox * propwin );	// create properties widgets

    // load the colour from the session
    //SessionLoad();

    // save the current colour to the session
    //SessionSave();
    
    void color_set_from_colorpicker();
};


#endif
