/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000-2002 Jason D. Hildebrand
 *  - jason@alumni.uwaterloo.ca
 *  - http://www.opensky.ca/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include "color.h"

void color_set_cb( GtkWidget *widget );

Color::Color( char * newname, char * id, char * defaultcolor ) :
    name( NULL ),
    identifier( NULL )
{
    name = strdup( newname );
    identifier = strdup( id );
    strncpy( stringval, defaultcolor, max_rgb_str_size );
    gdk_color_parse( stringval, &value );
    gdk_color_alloc( gdk_colormap_get_system(), &value );
}

Color * Color::clone()
{
    Color * newcol = new Color( name, identifier, stringval );
    return newcol;
}

Color::~Color()
{
    GdkColormap * colormap = gdk_colormap_get_system();
    gdk_colormap_free_colors( colormap, &value, 1 );
    if( name != NULL ) {
	free( name );
    }
    if( identifier != NULL ) {
	free( identifier );
    }
}

void Color::save_session( char * prop )
{
    gnome_config_set_string( prop, stringval );
}

void Color::load_session( char * prop )
{
    GdkColormap * colormap = gdk_colormap_get_system();
    gchar * colorstr;
    char propstr[100];

    gdk_colormap_free_colors( colormap, &value, 1 );

    // use the current color as a default value
    sprintf( propstr, "%s=%s", prop, stringval );
    colorstr = gnome_config_get_string_with_default( propstr, NULL );
    strcpy( stringval, colorstr );
    g_free( colorstr );

    // allocate the new color
    gdk_color_parse( stringval, &value );
    gdk_color_alloc( colormap, &value );
}

void Color::use( GdkGC * gc )
{
    gdk_gc_set_foreground (gc, &value );
}

#if 0
void Color::apply()
{
    GdkColormap * colormap;

    if( strcmp( newstringval, "" ) != 0 ) {
	colormap = gdk_colormap_get_system();

	// first free the existing color
	gdk_colormap_free_colors( colormap, &value, 1 );

	strcpy( stringval, newstringval );

	// parse and allocate the new value
	gdk_color_parse( stringval, &value );
	gdk_color_alloc( colormap, &value );
    }
}
#endif

GtkWidget * Color::new_props( GnomePropertyBox * propwin ) 
{
    GtkWidget * label;
    GtkWidget * hb;

    // store away the property box ptr, so we can set 
    // gnome_property_box_changed later
    prop_win = propwin;

    label = gtk_label_new( name );
    gtk_widget_show( label );

    cp = gnome_color_picker_new();

    gnome_color_picker_set_i16( GNOME_COLOR_PICKER( cp ),
				value.red,
				value.green,
				value.blue,
				255 );
    gtk_widget_show( cp );
    gtk_object_set_data( GTK_OBJECT( cp ), "colorobj", this );
    gtk_signal_connect (GTK_OBJECT ( cp ), "color_set",
			GTK_SIGNAL_FUNC (color_set_cb), NULL );

    hb = gtk_hbox_new( FALSE, 10 );
    gtk_box_pack_start_defaults( GTK_BOX( hb ), label );
    gtk_box_pack_start( GTK_BOX( hb ), cp, TRUE, FALSE, 0 );
    gtk_widget_show( hb );

    return( hb );
}

void Color::color_set_from_colorpicker()
{
    guint8 r,g,b;
    GdkColormap * colormap = gdk_colormap_get_system();

    gnome_color_picker_get_i8( GNOME_COLOR_PICKER( cp ), &r, &g, &b, NULL );
    g_snprintf( stringval, max_rgb_str_size, "#%02x%02x%02x", r, g, b);

    gdk_colormap_free_colors( colormap, &value, 1 );

    // allocate the new color
    gdk_color_parse( stringval, &value );
    gdk_color_alloc( colormap, &value );
    gnome_property_box_changed( prop_win );
}


void color_set_cb( GtkWidget *widget )
{
    Color * colorptr = (Color *)gtk_object_get_data( GTK_OBJECT( widget ), "colorobj" );
    colorptr->color_set_from_colorpicker();
}


