/*
 * GSysInfo Applet
 *  - A GNOME panel applet to display various system information.
 *  Copyright (C) 2000 Jason D. Hildebrand
 *  - jdhildeb@undergrad.math.uwaterloo.ca
 *  - http://www.undergrad.math.uwaterloo.ca/~jdhildeb/gsysinfo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

/* #include <config.h> */
#include <stdio.h>
#include <gnome.h>
#include "gsysinfo.h"
#include "properties.h"

static int prop_cancel (GtkWidget * w, gpointer data);
static void prop_apply (GtkWidget *w, int page, gpointer data);


// Properties
//
// - turn each bar on/off
// - change all colors
// - adjust size
// - adjust orientation
// - adjust update frequency

/* Create the properties window */
void
properties_window (AppletWidget * applet, gpointer data)
{
  static GnomeHelpMenuEntry help_entry = { NULL, "properties" };
  GSysInfoData * gd = data; 
  GtkWidget * t, * l;
  GtkWidget * timeout_spin;
  int r, g, b;

  help_entry.name = gnome_app_id;

  if (gd->prop_win) {
      gtk_widget_show (GTK_WIDGET (gd->prop_win));
      gdk_window_raise (GTK_WIDGET (gd->prop_win)->window);

      return;
  }
	
  gd->prop_win = GNOME_PROPERTY_BOX (gnome_property_box_new ());

  gnome_dialog_close_hides
    (GNOME_DIALOG (& (gd->prop_win->dialog)), TRUE);

  gtk_window_set_title (
	GTK_WINDOW (&GNOME_PROPERTY_BOX (gd->prop_win)->dialog.window),
	_("GSysInfo Settings"));
  
  /*
   *
   * General Properties
   *
   */
  t = gtk_table_new (5, 2, FALSE);
  gnome_property_box_append_page (GNOME_PROPERTY_BOX (gd->prop_win), t,
				  gtk_label_new (_("General")));


  /* Applet breadth */
  l = gtk_label_new (_("Delay between updates (milliseconds):")); 
  gtk_table_attach_defaults ( GTK_TABLE (t), l, 0, 1, 0, 1 ); 

  gd->timeout_adj = gtk_adjustment_new ( (gfloat) gd->timeout_t, 
					 (gfloat) 100, 
					 (gfloat) 100000, 
					 (gfloat) 100, 
					 (gfloat) 1000, 
					 (gfloat) 100 );
  timeout_spin = gtk_spin_button_new ( GTK_ADJUSTMENT (gd->timeout_adj), 1, 0 );
  gtk_table_attach_defaults ( GTK_TABLE (t), timeout_spin, 1, 2, 0, 1 );
  gtk_spin_button_set_update_policy ( GTK_SPIN_BUTTON (timeout_spin),
				     GTK_UPDATE_ALWAYS );
  gtk_signal_connect (GTK_OBJECT (gd->timeout_adj), "value_changed",
		     GTK_SIGNAL_FUNC (adj_value_changed_cb), gd);

  gd->loadavgtoggle = gtk_check_button_new_with_label( _("Show Load Average") );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( gd->loadavgtoggle ), gd->loadavg_on );
  gtk_table_attach_defaults( GTK_TABLE(t), gd->loadavgtoggle, 0, 1, 1, 2 );

  gd->loadtoggle = gtk_check_button_new_with_label( _("Show CPU usage") );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( gd->loadtoggle ), gd->load_on );
  gtk_table_attach_defaults( GTK_TABLE(t), gd->loadtoggle, 0, 1, 2, 3 );
  
  gd->memtoggle = gtk_check_button_new_with_label( _("Show memory usage") );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( gd->memtoggle ), gd->mem_on );
  gtk_table_attach_defaults( GTK_TABLE(t), gd->memtoggle, 0, 1, 3, 4 );

  gd->swaptoggle = gtk_check_button_new_with_label( _("Show swap space usage") );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( gd->swaptoggle ), gd->swap_on );
  gtk_table_attach_defaults( GTK_TABLE(t), gd->swaptoggle, 0, 1, 4, 5 );


    // set signals so that we can update the property window if anything
    // gets changed
  gtk_signal_connect (GTK_OBJECT (gd->loadavgtoggle), "toggled",
		      GTK_SIGNAL_FUNC (toggle_value_changed_cb), gd);

  gtk_signal_connect (GTK_OBJECT (gd->loadtoggle), "toggled",
		      GTK_SIGNAL_FUNC (toggle_value_changed_cb), gd);
  
  gtk_signal_connect (GTK_OBJECT (gd->memtoggle), "toggled",
		      GTK_SIGNAL_FUNC (toggle_value_changed_cb), gd);

  gtk_signal_connect (GTK_OBJECT (gd->swaptoggle), "toggled",
		      GTK_SIGNAL_FUNC (toggle_value_changed_cb), gd);


  /** Standard things */
  gtk_signal_connect (GTK_OBJECT (gd->prop_win), "destroy",
		      GTK_SIGNAL_FUNC (prop_cancel), gd);
	
  gtk_signal_connect (GTK_OBJECT (gd->prop_win), "delete_event",
		      GTK_SIGNAL_FUNC (prop_cancel), gd);
	
  gtk_signal_connect (GTK_OBJECT (gd->prop_win), "apply",
		      GTK_SIGNAL_FUNC (prop_apply), gd);

  gtk_signal_connect (GTK_OBJECT (gd->prop_win), "help",
		      GTK_SIGNAL_FUNC (gnome_help_pbox_display),
		      &help_entry);
	
  gtk_widget_show_all (GTK_WIDGET (gd->prop_win));

} /* properties_window */


/*
 *
 * Properties window button callbacks (apply, cancel, etc)
 *
 */
static int
prop_cancel (GtkWidget * w, gpointer data)
{
  GSysInfoData * gd = data;

  return FALSE;
} /* prop_cancel */

static void
prop_apply (GtkWidget *w, int page, gpointer data)
{
  GSysInfoData * gd = data;
  int timeoutval; 
  guint8 r, g, b;
  gchar *fn;

  /*
   * Update the running session from the properties.  The session
   * state will be saved when the applet exits and the panel tells it
   * to save state.
   */

  /*
   * Don't let the update function run while we're changing these
   * values.
   */
  gd->setup = FALSE;

  /*
   * Update the size
   */
  timeoutval = GTK_ADJUSTMENT (gd->timeout_adj)->value;

  if (timeoutval != gd->timeout_t) {
    gd->timeout_t = timeoutval;
    set_timeout( gd );
  }

  gd->loadavg_on = GTK_TOGGLE_BUTTON (gd->loadavgtoggle)->active;
  gd->load_on = GTK_TOGGLE_BUTTON (gd->loadtoggle)->active;
  gd->mem_on = GTK_TOGGLE_BUTTON (gd->memtoggle)->active;
  gd->swap_on = GTK_TOGGLE_BUTTON (gd->swaptoggle)->active;

  configure_layout( gd );
  gsysinfo_set_size (gd);

  gd->setup = TRUE;

  /* Make the panel save our config */
  //applet_widget_sync_config (APPLET_WIDGET (gd->applet));
} /* prop_apply */

/*
 *
 * Property element callbacks (whenever a property is changed one of
 * these is called)
 *
 */

void
adj_value_changed_cb ( GtkAdjustment * ignored, gpointer data )
{
  GSysInfoData * gd = data;

  gnome_property_box_changed (GNOME_PROPERTY_BOX (gd->prop_win)); 
} /* value_changed_cb */

void
toggle_value_changed_cb ( GtkToggleButton * ignored, gpointer data )
{
  GSysInfoData * gd = data;
  GtkWidget *	    active;
  int		    numactive = 0;

  if( GTK_TOGGLE_BUTTON( gd->loadavgtoggle )->active ) {
      active = gd->loadavgtoggle;
      numactive += 1;
  }
  if( GTK_TOGGLE_BUTTON( gd->loadtoggle )->active ) {
      active = gd->loadtoggle;
      numactive += 1;
  }
  if( GTK_TOGGLE_BUTTON( gd->memtoggle )->active ) {
      active = gd->memtoggle;
      numactive += 1;
  }
  if( GTK_TOGGLE_BUTTON( gd->swaptoggle )->active ) {
      active = gd->swaptoggle;
      numactive += 1;
  }
  if( numactive == 1 ) {
      gd->insensitive = active;
      gtk_widget_set_sensitive( active, FALSE );
  }
  if( numactive == 2 && gd->insensitive != NULL ) {
      gtk_widget_set_sensitive( gd->insensitive, TRUE );
      gd->insensitive = NULL;
  }

  gnome_property_box_changed (GNOME_PROPERTY_BOX (gd->prop_win)); 
} /* value_changed_cb */

void
col_value_changed_cb ( GtkObject * ignored, guint arg1, guint arg2,
		      guint arg3, guint arg4, gpointer data )
{
  GSysInfoData * gd = data;

  gnome_property_box_changed (GNOME_PROPERTY_BOX (gd->prop_win)); 
} /* col_value_changed_cb */


void
font_value_changed_cb ( GtkObject * ignored, gchar *arg1, gpointer data )
{
  GSysInfoData * gd = data;

  gnome_property_box_changed (GNOME_PROPERTY_BOX (gd->prop_win)); 
} /* font_value_changed_cb */

